#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
#include common_scripts\utility;
#include user_scripts\mp_patches\hawkins\hud;
#include user_scripts\mp_patches\hawkins\utils;


dropHumanWeapon(){
	dropGun = self getCurrentWeapon();
	if(self getWeaponAmmoClip(dropGun) == 0)
		self setWeaponAmmoClip(dropGun, 1);
	//if(!isSlotReplacement(dropGun))
	ammo = self getweaponammoclip( dropGun );
	ammo1 = self getweaponammoclip( dropGun, "right" );//default
    ammo2 = self getweaponammoclip( dropGun, "left" );
	stock = self getweaponammostock( dropGun );
    maxStock = weaponmaxammo( dropGun );
    if ( stock > maxStock )
            stock = maxStock;
			
	var_0 = self dropitem( dropGun );
	var_0 thread fixedGlitchedGuns();
	var_0.owner = self;
	//iPrintLn("ammo1 First: "+ammo1);
	var_0 thread watchpickup(dropGun,ammo1,ammo2,stock);
	//else{
	//	self iPrintLnBold("You can't drop this weapon");
	//	return;
	//}
	self iPrintlnBold("^3Dropped Weapon!");
	self takeWeapon(dropGun);
	//self replaceWeaponSlot();
}

watchpickup(weaponname,ammo1,ammo2,stock)
{
    self endon( "death" );
    level endon("game_ended");

    for (;;)
    {
        self waittill( "trigger", player, droppedWeapon );
		//weaponname2 = droppedWeapon getitemweaponname();
		//player iPrintLn(droppedWeapon[0]);
		player giveWeapon(weaponname);
		//iPrintLn("ammo1 Second: "+ammo1);
		player setWeaponAmmoClip(weaponname, ammo1);
		//player setWeaponAmmoClip(weaponname, ammo1, "left");
		//player setWeaponAmmoClip(weaponname, ammo2, "right");
		player setWeaponAmmoStock(weaponname, stock);
		droppedWeapon delete();
	}
}

getitemweaponname2()
{
    var_0 = self.classname;
    var_1 = getsubstr( var_0, 6 );
    return var_1;
}

getitemweaponname()
{
    var_0 = self.classname;
    var_1 = getsubstr( var_0, 7 );
    return var_1;
}

fixedGlitchedGuns(){
	oldOrigin = self.origin;
	wait 0.5;
	while(oldOrigin != self.origin){
		oldOrigin = self.origin;
		wait 0.5;
	}
		
	//iPrintLn(self.origin);
	self.origin = ((self.origin[0],self.origin[1],self.origin[2]+10));
}

isSlotReplacement(dropGun){
	if(dropGun == "h2_wa2000_mp_camo001" || dropGun == "h2_wa2000_mp_camo002" || dropGun == "h2_wa2000_mp_camo003"){
		return true;
	}
	else{
		return false;
	}
}

replaceWeaponSlot(){
	if(!self hasWeapon("h2_wa2000_mp_camo001")){
		self giveWeapon("h2_wa2000_mp_camo001");
		self setWeaponAmmoClip("h2_wa2000_mp_camo001", 0);
		self setWeaponAmmoStock("h2_wa2000_mp_camo001", 0);
		wait 0.2;
		self switchToWeapon("h2_wa2000_mp_camo001");
	}
	else if(!self hasWeapon("h2_wa2000_mp_camo002")){
		self giveWeapon("h2_wa2000_mp_camo002");
		self setWeaponAmmoClip("h2_wa2000_mp_camo002", 0);
		self setWeaponAmmoStock("h2_wa2000_mp_camo002", 0);
		wait 0.2;
		self switchToWeapon("h2_wa2000_mp_camo002");
	}
	else if(!self hasWeapon("h2_wa2000_mp_camo003")){
		self giveWeapon("h2_wa2000_mp_camo003");
		self setWeaponAmmoClip("h2_wa2000_mp_camo003", 0);
		self setWeaponAmmoStock("h2_wa2000_mp_camo003", 0);
		wait 0.2;
		self switchToWeapon("h2_wa2000_mp_camo003");
	}
}
DropMine()
{
	self endon ( "disconnect" );
	self endon ( "death" );
	self setlethalweapon("h1_c4_mp");
	self maps\mp\gametypes\_class::giveoffhand("h1_c4_mp");
	while(1)
	{
		self waittill( "grenade_fire", c4, weapname );
		if(c4 == "h1_c4_mp")
			break;
		else
			return;
	}
	self.Mines++;
	self.humanSkills["mine"] = 0;
	c4 waittill("missile_stuck");
	mineTrigger = spawn("trigger_radius",c4.origin,20,100,100);
	mine = spawn("script_model", c4.origin);
	//mine.angles = c4.angles;
	mineTrigger.angles = c4.angles;
	mine.Trigger = mineTrigger;
	mine.owner = self;
	mine.team = self.team;
	mine setModel("wpn_h1_c4_npc");
	mine thread maps\mp\gametypes\_weapons::createBombSquadModel( "weapon_c4_bombsquad", "tag_origin", self.team, self );
	mine thread DetonateMineTrigger();
	mine thread DetonateMineDamage();
	mine thread monitorCount(self);
	c4 delete();
}
monitorCount(owner){
	self waittill("explode");
	owner.Mines--;
}

DetonateMineTrigger()
{
	self endon("detonateD");
	while(1)
	{
		self.Trigger waittill("trigger", player);
		if(player.team == "axis")
		break;
		else
		return;
		wait 0.1;
	}
	self playsound ("claymore_activated");
	PlayFx( level.customFX["mine_flash"], self.origin );
	wait .5;
	self notify("detonateT");
	PlayFx( level.customFX["mine_explosion"], self.origin );
	self playsound("h1_briefcase_exp_mid");
	RadiusDamage(self.origin,250,600,100,self.owner);
	PlayRumbleOnPosition( "grenade_rumble", self.origin );
	earthquake( 0.4, 0.75, self.origin, 512 );
	self notify("explode");
	wait 0.5;
	self.Trigger delete();
	self delete();
	return;
}

DetonateMineDamage()
{
	self endon("detonateT");
	self setcandamage( true );
	self.maxhealth = 100000;
	self.health = self.maxhealth;
	while(1)
	{
		self waittill( "damage", damage, attacker, direction_vec, point, type, modelName, tagName, partName, iDFlags );
		break;
	}
	self playsound ("claymore_activated");
	PlayFx( level.customFX["mine_flash"], self.origin );
	wait .5;
	self notify("detonateD");
	PlayFx( level.customFX["mine_explosion"], self.origin );
	self playsound("h1_briefcase_exp_mid");
	RadiusDamage(self.origin,250,600,100,self.owner);
	PlayRumbleOnPosition( "grenade_rumble", self.origin );
	earthquake( 0.4, 0.75, self.origin, 512 );
	self notify("explode");
	wait 0.5;
	self.Trigger delete();
	self delete();
	return;
}
doTeleport(i)
{
	self notify( "EXTT" );
	self endon( "disconnect" );
	self endon( "death" );
	self endon( "EXTT" );
	self iprintlnBold("^2Throw smoke where you wish to teleport!");
	while(i>0)
	{
		self giveWeapon("smoke_grenade_mp", 7, false);
		self setWeaponAmmoStock("smoke_grenade_mp", 0);
		self setWeaponAmmoClip("smoke_grenade_mp", 1);
		if(self.team == "allies")
		{
			//self SetOffhandPrimaryClass( "smoke" );
			//self SetOffhandSecondaryClass( "c4" );
		}
		else
		{
			//self SetOffhandPrimaryClass( "smoke" );
			//self SetOffhandSecondaryClass( "other" );
		}
		self thread DeathCheck(i);
		self waittill( "grenade_fire", grenadeWeapon, weapname );
		i--;
		if(weapname=="smoke_grenade_mp")
		{
			self _disableWeapon();
			self _disableOffhandWeapons();
			self freezeControls(true);
			self.health = self.maxhealth;
			self playerLinkTo(grenadeWeapon);
			self hide();
			self thread watchSpecNade();
			self thread fixNadeVision(grenadeWeapon);
			grenadeWeapon waittill( "explode");
			self notify( "specnade" );
			self unlink();
			self show();
			self _enableWeapon();
			self _enableOffhandWeapons();
			self freezeControls(false);
			self thread CheckStuck();
			if(i>0)
			self iprintlnBold("^2Only "+i+" grenade left!");
		}
		
	}
	if(self.TK)
	{
		//self SetOffhandSecondaryClass( "other" );
		//self SetOffhandPrimaryClass( "throwingknife" );
	}
	self.SG = 0;
	self notify( "EXTT" );
}
DeathCheck(i)
{
	self notify("SLER");
	self endon("SLER");
	self waittill_any("death","EXTT");
	self.SSG=i;
}
CheckStuck()
{
	self notify("RepeatStuck");
	self endon("RepeatStuck");
	self.Stuck = self.origin;
	wait 15;
	if(self.Stuck == self.origin)
	{
		self iprintlnBold("^1Get Stuck???");
		wait 2;
		self iprintlnBold("^2Here is one more grenade...");
		wait 2;
		self iprintlnBold("^1Dont Waste It...");
		wait 2;
		self thread doTeleport(1);
	}
}
fixNadeVision(grenade)
{
	self endon( "specnade" );
	self endon( "death" );
	while(1)
	{
		self setPlayerAngles(VectorToAngles(grenade.origin - self.origin));
		wait .01;
	}
}
watchSpecNade()
{
	self setClientDvar( "cg_drawgun", 0);
	self waittill_any( "death", "specnade" );
	self setClientDvar( "cg_drawgun", 1);
}

martywarn()
{	
	foreach(player in level.players)
	{	
		player iPrintlnBold("^1EXTREME Warning: ^3Predator Missle Detected!");
		self playsound("flag_spawned");
	}
}
giveUnlimitedAmmo()
{
	self endon ( "disconnect" );
	self endon ( "death" );
	for(;;) 
	{
		currentWeapon = self getCurrentWeapon();
		if ( currentWeapon != "none" && currentWeapon != level.customWeapon["deserteagle"] && currentWeapon != level.customWeapon["thundergun"] && currentWeapon != level.customWeapon["raygun"])
		{
			if( isSubStr( self getCurrentWeapon(), "_akimbo" ) )
			{
				self setWeaponAmmoClip( currentweapon, 9999, "left" );
				self setWeaponAmmoClip( currentweapon, 9999, "right" );
			}
			else
			{
				self setWeaponAmmoClip( currentWeapon, 9999 );
				self GiveMaxAmmo( currentWeapon );
			}
		}
		wait 0.1;
	}
}

SCTS()
{
	if(level.AMT<25)
	{
		level.AMT+=1;
		user_scripts\mp_patches\hawkins\mapUtils::CreateTurret(self.origin + (0,0,40));
		wait 60;
		self.CTD=0;
	}
}

Invisibility()
{
    self endon ( "disconnect" ); 
	self hide();
	InvisibilityOverlay = newClientHudElem( self );
	InvisibilityOverlay.horzAlign = "fullscreen";
	InvisibilityOverlay.vertAlign = "fullscreen";
	InvisibilityOverlay setShader( "combathigh_overlay", 640, 480 );
	InvisibilityOverlay.color=((0/255),(0/255),(0/255));
	InvisibilityOverlay.archive = true;
	InvisibilityOverlay.sort = 10;

	InvisibilityOverlay2 = newClientHudElem( self );
	InvisibilityOverlay2.horzAlign = "fullscreen";
	InvisibilityOverlay2.vertAlign = "fullscreen";
	InvisibilityOverlay2 setShader( "combathigh_overlay", 640, 480 );
	InvisibilityOverlay2.color=((0/255),(0/255),(0/255));
	InvisibilityOverlay2.archive = true;
	InvisibilityOverlay2.sort = 11;

	wait 10;
	self iPrintlnBold("^2Visible Again In 5!");
	wait 1;
	self iPrintlnBold("^2Visible Again In 4!");
	wait 1;
	self iPrintlnBold("^2Visible Again In 3!");
	wait 1;
	self iPrintlnBold("^2Visible Again In 2!");
	wait 1;
	self iPrintlnBold("^2Visible Again In 1!");
	wait 1;
	self iPrintlnBold("^3Now Visible!");
	self show();
	InvisibilityOverlay destroy();
	InvisibilityOverlay2 destroy();
	self.zombieSkills["invis"]=0;
}

flyingZombie()
{		
	self endon ( "disconnect" ); 
	self endon("death");
	self.flyingEnergy=80;
	self ZombieSkillBar();
	self.skillText setSafeText("^3Flying Lives: "+self.flyingLives+"\n^7Flying Energy");
	wait 1;
	self iprintlnBold("Hold [{+activate}] to Fly");
	while(isalive(self))
	{
		if(self useButtonPressed() && self.flyingEnergy>0)
		{		
			playfx(level.customFX["fire_smoke"],self gettagorigin("j_spine4"));
			earthquake(.15,.2,self gettagorigin("j_spine4"),50);
			self thread flyingSound();
			self.flyingEnergy--;
			if(self getvelocity()[2]<300)
				self setvelocity(self getvelocity()+(0,0,60));
		}
		if(self.flyingEnergy<80 &&!self useButtonPressed())	
		{
			wait .1;
			self.flyingEnergy++;
		}
		self.skillBar updateBar(self.flyingEnergy/80);
		self.skillBar.bar.color=(1,self.flyingEnergy/80,self.flyingEnergy/80);
		wait .05;
	}
}
flyingSound()
{
	if(!self.PJS)
	{
		self.PJS=1;
		self playsound("veh_b2_sonic_boom");
		wait 1;
		self playSound( "sentry_explode_smoke" );
		self.PJS=0;
	}
}

CB0MB()
{
	o=self;
	/*o thread zkdeathz();*/
	b0=spawn("script_model",(15000,0,2300));
	b1=spawn("script_model",(15000,1000,2300));
	b2=spawn("script_model",(15000,-2000,2300));
	b3=spawn("script_model",(15000,-1000,2300));
	b0 setModel("vehicle_b2_bomber");
	b1 setModel("vehicle_av8b_harrier_jet_opfor_mp");
	b2 setModel("vehicle_av8b_harrier_jet_opfor_mp");
	b3 setModel("vehicle_b2_bomber");
	b0.angles=(0,180,0);
	b1.angles=(0,180,0);
	b2.angles=(0,180,0);
	b3.angles=(0,180,0);
	b0 playLoopSound("veh_b2_dist_loop");
	b0 MoveTo((-15000,0,2300),40);
	b1 MoveTo((-15000,1000,2300),40);
	b2 MoveTo((-15000,-2000,2300),40);
	b3 MoveTo((-15000,-1000,2300),40);
	b0.owner=self;
	b1.owner=self;
	b2.owner=self;
	b3.owner=self;
	b0.team=self.team;
	b1.team=self.team;
	b2.team=self.team;
	b3.team=self.team;
	b0.killCamEnt=self;
	b1.killCamEnt=self;
	b2.killCamEnt=self;
	b3.killCamEnt=self;
	self thread ROAT(b0,30,"ac_died");
	self thread ROAT(b1,30,"ac_died");
	self thread ROAT(b2,30,"ac_died");
	self thread ROAT(b3,30,"ac_died");
	self thread ROATZ(b0,"ac_died");
	self thread ROATZ(b1,"ac_died");
	self thread ROATZ(b2,"ac_died");
	self thread ROATZ(b3,"ac_died");
	foreach(player in level.players)
	{	
		player iPrintlnBold("^1ZOMBIEKILLA JET ^7INCOMING!");
		if (player.team == "axis")
		{
			if( player.perkz["coldblooded"] != 1 || player.perkz["coldblooded"] != 2)	{
				player thread RB0MB(b0,b1,b2,b3,o,player);	
			}	
		}
	} 
}
ROAT(obj,time,reason){
	self endon ( "disconnect" );
	wait time;
	obj delete();
	self notify(reason);
}
ROATZ(obj,reason){
	self endon ( "disconnect" );
	self waittill ("death");
	obj delete();
	self notify(reason);
}
/*zkdeathz()
{	self endon("ac_died");
	self waittill ("death");
	level notify ("ac_diedz");
}*/
RB0MB(b0,b1,b2,b3,o,v){
	self endon ( "disconnect" );
	self endon ("ac_diedz");
	v endon("ac_died");
	s="stinger_mp";
	while(1)
	{
		MagicBullet(s,b0.origin,v.origin,o);
		wait 3;
		/*MagicBullet(s,b0.origin,v.origin,o);*/
		wait 5;
		MagicBullet(s,b1.origin,v.origin,o);
		wait 6;
		/*MagicBullet(s,b1.origin,v.origin,o);*/
		wait 3;
		MagicBullet(s,b2.origin,v.origin,o);
		wait 2;
		/*MagicBullet(s,b2.origin,v.origin,o);*/
		wait 5;
		MagicBullet(s,b3.origin,v.origin,o);
		wait 3;
		MagicBullet(s,b3.origin,v.origin,o);
		wait 5.43;
	} 
}
cBombWait()
{	self endon ( "disconnect" );
	self endon ( "death" );
	self.cbcount = 150;
	level.ClearKillstreaks=0;
	while(self.cbcount > 0)
	{	
		wait 1;
		self.cbcount--;
	}
	self.humanSkills["StringerPro"] = 0;
	level.ClearKillstreaks=1;
}
empWait()
{	self endon ( "disconnect" );
	self endon ( "death" );
	self.cbcount = 15;
	
	while(self.cbcount > 0)
	{	
		wait 1;
		if(self.cbcount == 115) 
		self.cbcount--;
	}
}	
/*doChopperGunner()
{	self endon ( "disconnect" );
    self endon ( "death" );
	self hide();
	self.coldblz = self.perkz["coldblooded"];
	self.perkz["coldblooded"] = 2;
	for(j = 68; j > 0; j--)
	{	self.maxhealth = 9000;
		self.health = self.maxhealth;
		wait 1;
	}
	self iPrintlnBold("^1You have 5 Seconds then you return to normal."); 
	self.humanSkills["StringerPro"] = 0;
	wait 5;
	self.perkz["coldblooded"] = self.coldblz;
	self show();
	self.maxhealth = self.maxhp;
	self.health = self.maxhealth;
}*/
doSentrz()
{	self endon ( "disconnect" );
    self endon ( "death" );
	self notifyOnPlayerCommand("dpad_right", "+actionslot 4");
	self waittill( "dpad_right" );
	wait 2;
	self.SZ = 0;
}

doNV()
{
	self notify("loopfixNV");
	self endon("death");
	self endon("loopfixNV");
	self iPrintlnBold("^2Night Vision Bought!");
	wait 2;
	self iPrintlnBold("^3Hold [{+activate}] To Turn On ^2Night Vision!");
	while(isAlive(self))
	{
		if(self useButtonPressed())
		{
			wait 0.2;
			if(self useButtonPressed())
			{
				wait 0.2;
				if(self useButtonPressed())
				{
					if(!self.NVM)
					{
						self.NVM = 1;
						self iPrintlnBold("^2Night Vision Actived!");
						self VisionSetNakedForPlayer("default_night_mp", 1);
					}
					else if(self.NVM)
					{
						self.NVM = 0;
						self iPrintlnBold("^1Night Vision Disabled!");
						self VisionSetNakedForPlayer(level.HVision, 1);
					}
				}
			}
		}
		wait 1;
	}
}

doNukemz()
	{
	self endon("disconnect");
	self endon("death");
	self giveweapon("nuke_mp");
	self setactionslot(4, "weapon", "nuke_mp");
	self thread checkIfNuking();
	
}

checkIfUsePredator(){
	while(self getCurrentWeapon() != "predator_mp")
		wait 0.025;
	wait 1;
	self maps\mp\h2_killstreaks\_remotemissile::tryUsePredatorMissile(false);
	self takeWeapon("predator_mp");
	self setactionslot(3, "");
	self.zombieSkills["predator"] = false;
}

checkIfNuking(){
	while(self getCurrentWeapon() != "nuke_mp")
		wait 0.025;
	self thread StartNukeTimer();
	self notify( "used_nuke" );
	self thread maps\mp\h2_killstreaks\_nuke::doNuke( false );
	wait 0.5;
	self takeWeapon("nuke_mp");
	self setactionslot(4, "");
	self switchToWeapon( self getLastWeapon() );
}

StartNukeTimer()
{
	self endon("death");
	self endon("disconnect");
	level.GameText thread showGameText("^1" + self.name + " ^7Bought A ^2NUKE! ^7It will Detonate in " + level.soundTimer + " Seconds!", 5);
	self thread NukeWarningSound();
	while(level.soundTimer >= 10)
	{
		if(level.soundTimer == 30){
			level.GameText thread showGameText("^1" + self.name + "'s ^2NUKE Detonates ^7in " + level.soundTimer + " Seconds!", 5);
			self thread NukeWarningSound();
		}
		if(level.soundTimer == 10){
			level.GameText thread showGameText("^1" + self.name + "'s ^2NUKE Detonates ^7in " + level.soundTimer + " Seconds!", 5);
			self thread NukeWarningSound();
		}
		wait 0.025;
	}
}

NukeWarningSound()
{
	foreach(player in level.players)
	{
		player playLocalSound( "flag_spawned" );
	}
}

doTempzHealth()
{
	self.maxhealth = 1500;
	self.health = self.maxhealth;
	wait 20;
	self thread SetHZHealth();
	self.zombieSkills["1500health"]=0;
}

SetHZHealth()
{
	self.maxhealth = self.maxhp;
	self.health = self.maxhealth;
}

JavelinPro()
{
	self endon("death");
	self.oldWeapon = self getCurrentWeapon();
	self giveWeapon( "stinger_mp" );
	self setWeaponAmmoClip( "stinger_mp", 1 );
	self setWeaponAmmoStock( "stinger_mp", 1 );
	wait 0.1;
	self switchToWeapon( "stinger_mp" );
	while(isalive(self))
	{
		if(self getCurrentWeapon() != "stinger_mp" && self.oldWeapon != self getCurrentWeapon())
			self.oldWeapon = self getCurrentWeapon();
		if(self AttackButtonPressed() && self adsButtonPressed() && self getCurrentWeapon()  == "stinger_mp" && self GetWeaponAmmoClip(self getCurrentWeapon()) == 1)
		{
			MagicBullet( "stinger_mp", self getTagOrigin("tag_eye"), self GetCursorPos(), self );
			self setWeaponAmmoClip("stinger_mp", 0);
			self setWeaponAmmoStock("stinger_mp", 0);
			self switchToWeapon(self.oldWeapon);
			wait 2;
			self giveStartAmmo("stinger_mp");
			self switchToWeapon("stinger_mp");
		}
		wait 0.1;
	}
}
giveRaygun()
{
	self endon("death");
	//h2_deserteagle_mp_camo041
	//iPrintLn(level.customWeapon["raygun"]);
	self _giveWeapon(level.customWeapon["raygun"]);
	self GiveMaxAmmo( level.customWeapon["raygun"] );
	wait 0.1;
	self switchToWeapon(level.customWeapon["raygun"]);
	for(;;)
	{
		self waittill( "weapon_fired", weaponName );
		if( self getCurrentWeapon() != level.customWeapon["raygun"] ) 
			continue;
		start = self getTagOrigin( "tag_eye" );
		end = self getTagOrigin( "tag_eye" ) + vecscale( anglestoforward( self getPlayerAngles() ), 100000 );
		trace = bulletTrace( start, end, true, self );
		thread doLaserFX( self getTagOrigin( "tag_eye" ), anglestoforward( self getPlayerAngles() ), trace["position"] );
		if(self GetAmmoCount(level.customWeapon["raygun"]) == 0)
		{
			self takeWeapon( level.customWeapon["raygun"] );
			self.humanSkills["raygun"] = false;
			break;
		}
		wait 0.1;
	}
}
	

doAC130()
{
	self thread maps\mp\h2_killstreaks\_ac130::tryUseAC130( false );
	self hide();
	self.isUsingAC130 = true;
	self thread disableFireWhileAC130();
}

disableFireWhileAC130(){
	while(self.isUsingAC130){
		self allowFire(false);
		wait 0.025;
	}
	self allowFire(true);
	self show();
}

doLaserFX( startPos, direction, endPos )
{
	doDamage = 1;

	for( i = 1; ; i ++ ) /*start from 1 because 0 is the player origin*/
	{
		pos = startPos + vecscale( direction, i * 150 ); /*how far the bullet goes every "refresh"*/

		if( distance( startPos, pos ) > 9000 ) /*it's over 9000!. If the bullet goes too far it vanishes. No FX and no explosion, so no damage.*/
		{
			doDamage = 0;
			break;
		}

		trace = bulletTrace( startPos, pos, true, self );

		if( !bulletTracePassed( startPos, pos, true, self ) )
		{
			impactFX = spawnFX( level.customFX["red_blink_light"], bulletTrace( startPos, pos, true, self )["position"] );
			level.FX_count ++;
			triggerFX( impactFX );

			wait( 0.2 );

			impactFX delete();
			level.FX_count --;
			
			break;
		}

		laserFX = spawnFX( level.customFX["raygun_laser"], pos ); /*this is the "main" laser effect, the central one, this isn't affected by the FX limit*/
		level.FX_count ++;
		triggerFX( laserFX );

		laserFX thread deleteAfterTime( 0.1 );

		if( level.FX_count < 200 ) /*if there are too many FX's, the following ones don't spawn.*/
		{
			/*FX's spawned around the "main" FX with a randomly distance, to make it look cooler ;)*/
			for( j = 0; j < 3; j ++ )
			{
				laserFX = spawnFX( level.customFX["raygun_laser"], pos + (randomInt( 50 ) / 10, randomInt( 50 ) / 10, randomInt( 50 ) / 10) - vecscale( direction, i * randomInt( 10 ) * 3 ) );
				laserFX.angles = (90,90,90);
				level.FX_count ++;
				triggerFX( laserFX );

				laserFX thread deleteAfterTime( 0.05 + randomInt( 3 ) * 0.05 );
			}
		}

		wait( 0.05 );
	}

	if( doDamage )
	self radiusDamage( endPos, 300, 150, 20, self );
	 
	
	
}

vecscale( vec, scalar )
{
	return ( vec[0] * scalar, vec[1] * scalar, vec[2] * scalar );
}

deleteAfterTime( time )
{
	wait time;
	self delete();
}


doBots(numberOfTestClients)
{
for(i = 0; i < numberOfTestClients; i++)
	{
	ent[i] = addtestclient();
	ent[i] setPlayerData( "customClasses", 0, "name", "Bot "+i);
	ent[i].LanName = "Bot "+i;
	if (!isdefined(ent[i]))
		{
			wait 1;
			continue;
		}
	ent[i].pers["isBot"] = true;
	ent[i] thread TestClient(i);
	//ent[i] thread TestSoundBot(i);
	wait 0.2;
	}
}
TestClient(i)
{
	self endon( "disconnect" );
	while(!isdefined(self.pers["team"]))
	{
		wait 1;
		self maps\mp\gametypes\_menus::addToTeam( "allies" );
		self notify("menuresponse", game["menu_team"], "allies");
		wait 0.5;
		self notify("menuresponse", "changeclass", "class3");
	}
}

TestSoundBot(i)
{
	self endon( "death" );
	while(1)
	{
		wait 3;
		self playsound("UK_mp_rsp_areyoucrazy");
		iprintlnBold("playsound");
		wait 3;
		self playlocalsound("UK_mp_rsp_areyoucrazy");
		iprintlnBold("playlocalsound");
	}
}

GDegealez()
{	
	self _giveWeapon( level.customWeapon["deserteagle"] );
	wait 0.1;
	self switchToWeapon(level.customWeapon["deserteagle"]);
	self GiveMaxAmmo( level.customWeapon["deserteagle"] );
	self setWeaponAmmoClip( level.customWeapon["deserteagle"], WeaponClipSize(level.customWeapon["deserteagle"]) );
	self thread DammoC();
}

DammoC() 
{		
	self endon ( "disconnect" ); 
	self endon ( "death" );
	self endon ( "endDesert" );
	for(;;)
	{
		self waittill ( "weapon_fired" );
		currentWeapon = self getCurrentWeapon(); 
		if ( currentWeapon == level.customWeapon["deserteagle"] )
		{
			forward = self getTagOrigin("j_head");
			end = self thread vector_scal(anglestoforward(self getPlayerAngles()),1000000);
			pos = BulletTrace( forward, end, 0, self )[ "position" ];
			playfx(level.customFX["mine_flash"], pos);
			RadiusDamage(pos, 100, 500, 100, self );
			if(self GetAmmoCount(level.customWeapon["deserteagle"]) <= 0)
			{
				self takeWeapon( level.customWeapon["deserteagle"] );
				self switchToWeapon( self getLastWeapon() );
				self.humanSkills["ExplosiveDesertEagle"] = 0;
				break;
			}
		}
		wait 0.1;
	}
}

BlackOutHumans()
{
	iprintlnBold("^1Zombies Blacked Out Humans for 20 Secs!");
	level.BlackoutHumans = true;
	wait 1;
	for(i=20;i>0;i--)
	{
		level.GameText setSafeText("^1Humans Blacked Out For " + i + " More Seconds");
		if(i<10)
			level playSoundToAll("ui_mp_timer_countdown");
		wait 1;
	}
	level.BlackoutHumans = false;
	self thread enableOpZombieSkills();
	level.GameText thread showGameText("^3Human Blackout Over!", 2);
}

maxAmmoCooldown(){
	self.humanSkills["ExplosiveDesertEagle"] = true;
	wait 2;
	self.humanSkills["ExplosiveDesertEagle"] = false;
}

BowExplosive() 
{		
	self endon ( "disconnect" ); 
	self endon ( "death" );
	for(;;)
	{
		self waittill ( "weapon_fired" );
		currentWeapon = self getCurrentWeapon(); 
		if ( currentWeapon == "bow_mp" )
		{
			forward = self getTagOrigin("j_head");
			end = self thread vector_scal(anglestoforward(self getPlayerAngles()),1000000);
			pos = BulletTrace( forward, end, 0, self )[ "position" ];
			playfx(level.customFX["mine_flash"], pos);
			earthquake( 0.4, 0.75, pos, 512 );
			RadiusDamage(pos, 100, 500, 100, self );
			if(self GetAmmoCount("bow_mp") <= 0)
			{
				self takeWeapon( "bow_mp" );
				self switchToWeapon( self getLastWeapon() );
				self setclientdvar("ui_hextra_bow", 1);
				self.humanSkills["bow"] = false;
			}
		}
		wait 0.1;
	}
}


SlowHumans()
{
	level.slowHumans = 1;
	iprintlnBold("^1Zombies Slowed Down Humans for 15 Secs!");
	wait 1;
	for(i=20;i>0;i--)
	{
		slowHumansDown();
		level.GameText setSafeText("^1Humans Slow Down For " + i + " More Seconds!");
		if(i<5)
			level playSoundToAll("ui_mp_timer_countdown");
		wait 1;
	}
	wait 0.2;
	foreach(player in level.players)
	{
		if(player.team == "allies") 	
		{
			player thread unslowPlayerDown();
		}
	}
	level.slowHumans = 0;
	self thread enableOpZombieSkills();
	level.GameText thread showGameText("^3Human Slow Down Over!", 2);
}

slowHumansDown()
{
	foreach(player in level.players)
	{
		if(player.team == "allies") 	
		{
			player SetMoveSpeedScale( 0.20 );
		}
	}
}

unslowPlayerDown()
{
	self SetMoveSpeedScale( self.speedScale );
}
hintElectroMonkey(){
	wait 2;
	self iprintlnText("^2Press [{+actionslot 4}] to active Electro-Monkey-Pulse!");
}


freezeZombies()
{	
	wait 1;
	iPrintlnBold("^1Humans Bought ^2Electro Monkey Pulse!");
	for(i=0;i<=15;i++){
		foreach(player in level.players)
		{	
			if(player.team == "axis")
				player thread toggleMovement(true);
		}
		wait 1;
	}
	foreach(player in level.players)
	{	
		player thread toggleMovement(false);
	}
	player iPrintlnBold("^2Zombies Un-Frozen");
	self.humanSkills["freezeZombies"] = 0;
}

toggleMovement(value){
	self freezeControls(value);
}

doLevEmpzz()
{	
	foreach(player in level.players)
	{	
		player iPrintlnBold("^1Zombies Frozen");
		player thread doEmpz();
	}
	wait 1;
	thread ResetClientVisions();
	wait 14;
	foreach(player in level.players)
	{	
		player iPrintlnBold("^2Zombies Un-Frozen");
		player notify ("EMPZEND");
		player freezeControls(false);
		player thread doEmpzwait();
	}
}
doEmpz()
{	self endon ( "disconnect" );
	self endon ("EMPZEND");
	for(j = 15; j > 0; j--)
	{	
		if(self.team == "axis")
		{	
			self freezeControls(true);
		}
		wait 1;
	}
	self freezeControls(false);
}
doEmpzwait()
{	wait 1;
	self iPrintlnBold("^2Zombies Un-Frozen");
	self freezeControls(false);
	wait 1;
	self freezeControls(false);	
}

MonkeyBomb()
{
	//self SetOffhandSecondaryClass( "smoke" );
	self giveWeapon("concussion_grenade_mp");
	monkeyRadius = 1000;
	while(self GetAmmoCount("concussion_grenade_mp") > 0)
	{
		self waittill( "grenade_fire", grenade, weapname );
		if(weapname == "concussion_grenade_mp"){
			grenade waittill("missile_stuck");
			self setclientdvar("ui_hextra_monkey", 1);
			self takeWeapon("concussion_grenade_mp");
			grenade playsound("NS_mp_rsp_sorry");
			self thread pullZombies(grenade, monkeyRadius);
			wait 8.7;
			grenade playsound("exp_suitcase_bomb_main");
			PlayFx( level._effect[ "sentry_explode_mp" ], grenade.origin );
			PlayFx( level.customFX["mine_flash"], grenade.origin );
			RadiusDamage(grenade.origin,250,600,100,self);
			PlayRumbleOnPosition( "grenade_rumble", self );
			earthquake( 0.4, 0.75, grenade.origin, 512 );
			grenade delete();
		}
	}
}

pullZombies(grenade, monkeyRadius){
	while(isDefined(grenade))
	{
		foreach(player in level.players)
		{
			if(player.team == "axis"){
				if(distance(grenade.origin, player.origin) > monkeyRadius)
					continue;
				angles = VectorToAngles( (grenade.origin[0],grenade.origin[1],player.origin[2]) - player.origin );
				AtF = anglestoforward(angles);
				player setplayerangles(angles);
				if(distance(grenade.origin, player.origin) < 100){
					player SetStance( "prone" );
				}
				else
					player setVelocity(player getVelocity()+(AtF[0]*(300*(2)),AtF[1]*(300*(2)),(AtF[2]+0.25)*(300*(2))));
			}
		}
		wait 0.5;
	}
}

flameZombie()
{
	self endon ( "disconnect" ); 
	self.zombieSkills["flame"] = 1;
	self thread flameZombieDamage();
	self thread flameZombieTimer();
	self setClientDvar("cg_drawDamageDirection", 0);
	while(self.zombieSkills["flame"])
	{
		playfx(level.customFX["fire_ball"],self gettagorigin("back_mid"));
		playfx(level.customFX["fire_ball"],self gettagorigin("pelvis"));
		self SetMoveSpeedScale( 5 );
		wait .1;
	}
}
flameZombieDamage()
{	self endon ( "disconnect" ); 
	while(self.zombieSkills["flame"])
	{
		RadiusDamage( self.origin, 750, 51, 10, self );
		self playSound( "sentry_explode_smoke" );
		wait 1;
	}
}

flameZombieTimer(){
	for(i=50;i>0;i--){
		self ZombieSkillBar();
		self.skillText setSafeText("\nFlaming Zombie Power");
		self.skillBar updateBar(i/50);
		self.skillBar.bar.color=(1,i/50,i/50);
		wait 1;
	}
	self.zombieSkills["flame"] = 0;
	self notify("zombieSkillOver");
	self setClientDvar("cg_drawDamageDirection", 1);
}

isOPzombie(){
	if(self.zombieSkills["radio"] || self.zombieSkills["flying"] || self.zombieSkills["flame"])
		return true;
	else
		return false;
}

radioActive()
{
	self endon ( "disconnect" ); 
	self.zombieSkills["radio"] = 1;
	foreach(player in level.players)	
		player iPrintlnBold("^1Watch Out: ^3Radioactive Zombie Detected!");
	self thread radioActiveDamage();
	self thread radioActiveFX();
	self thread radioActiveTimer();
	self setClientDvar("cg_drawDamageDirection", 0);
	while(self.zombieSkills["radio"])
	{
		self SetStance( "prone" );
		self SetMoveSpeedScale( 18 );
		wait 1;
	}
	self SetStance( "stand" );
	self setClientDvar("cg_drawDamageDirection", 1);
	self.zombieSkills["radio"] = 0;
	self thread enableOpZombieSkills();
}

radioActiveTimer(){
	for(i=50;i>0;i--){
		self ZombieSkillBar();
		self.skillText setSafeText("\nRadio Active Zombie Power");
		self.skillBar updateBar(i/50);
		self.skillBar.bar.color=(1,i/50,i/50);
		wait 1;
	}
	self.zombieSkills["radio"] = 0;
	self notify("zombieSkillOver");
}

radioActiveFX(){
	self endon ( "disconnect" ); 
	while(self.zombieSkills["radio"])
	{
		playfx(level.customFX["fire_smoke"],self gettagorigin("j_head"));
		playfx(level.customFX["fire_smoke"],self gettagorigin("j_spine4"));
		wait 0.1;
	}
}

radioActiveDamage(){
	self endon ( "disconnect" ); 
	while(self.zombieSkills["radio"])
	{
		RadiusDamage(self.origin, 500, 51, 10, self );
		self playSound( "sentry_gun_beep" );
		wait 0.5;
	}
}


InvisWait(){
	self endon ( "death" );
	wait 15;
	self iprintlnText("^2Visible Again In 5!");
	wait 1;
	self iprintlnText("^2Visible Again In 4!");
	wait 1;
	self iprintlnText("^2Visible Again In 3!");
	wait 1;
	self iprintlnText("^2Visible Again In 2!");
	wait 1;
	self iprintlnText("^2Visible Again In 1!");
	wait 1;
}

zombie1500HP(){
	self.maxhealth = 1500;
	self.health = self.maxhealth;
	self zombie1500HPTimer();
	self.maxhealth = self.maxhp;
	self.health = self.maxhealth;
	self setclientdvar("ui_z_50hp", 1);
	self thread enableOpZombieSkills();
}

zombie1500HPTimer(){
	self endon("death");
	self endon("disconnect");
	for(i=20;i>0;i--){
		if(i <= 10)
			self iprintlnText("^3"+i+" Seconds Left Of 1500 HP!");
		wait 1;
	}
}


ThunderGunner()
{
	self endon("disconnect");
	self endon ("death");
	self.thunderammo = getDvarInt("thundergun_ammo");
	oldweapon = self getCurrentWeapon();
	self giveWeapon("javelin_mp", 0, false);
	self switchToWeapon("javelin_mp");
	self thread thunderGunDamage();
	while(self.thunderammo > 0)
		wait 0.1;
	self takeWeapon("javelin_mp");
	self switchToWeapon(oldweapon);
	self.humanSkills["thundergun"] = false;
}

ThundergunSound(){
	for(i=0;i<10;i++){
		self playSound("sentry_gun_beep");
		self playSound("mp_suitcase_pickup");
		wait 0.025;
	}
}

/*
self playSound("sentry_gun_beep");
	wait 0.1;
	self playSound("mine_betty_spin");
	wait 0.1;
	self playSound("mine_betty_click");
	wait 0.1;
	self playSound("claymore_activated");
	wait 0.1;
	self playSound("claymore_activated");
	wait 0.1;
	self playSound("sentry_gun_beep");
	wait 0.1;
	self playSound("mine_betty_spin");
	wait 0.1;
	self playSound("mp_killconfirm_tags_drop");
	wait 0.1;
	self playSound("mp_killconfirm_tags_drop");
	wait 0.1;
	self playSound("sentry_gun_beep");
	self playSound("ac130_weapon_switch");
*/

thunderGunDamage(){
	self endon("death");
	while(1)
	{
		if(self AttackButtonPressed() && self getCurrentWeapon()  == "javelin_mp" && self GetWeaponAmmoClip(self getCurrentWeapon()) == 1)
		{
			self.thunderammo--;
			self giveStartAmmo("javelin_mp");
			if(self getCurrentWeapon() != "javelin_mp" && self.oldWeapon2 != self getCurrentWeapon())
				self.oldWeapon2 = self getCurrentWeapon();
			self thread ThundergunSound();
			for(i=0;i<15;i++){
				ForwardTrace = Bullettrace(self getEye(),self getEye()+anglestoforward(self getplayerangles())*100000,true,self);
				playerAngles = self GetPlayerAngles();
				AtF = AnglesToForward(playerAngles);
				foreach(player in level.players)
				{
					if(player.team == self.team)
						continue;
						
					enemyToSelf = distance(self.origin,player.origin);
					if(enemyToSelf>980)
						continue;
					
					if(ForwardTrace["entity"]!=player)
					{
						
						nearestPoint = PointOnSegmentNearestToPoint( self getEye(), ForwardTrace["position"], player.origin );
						PtoO = distance(player.origin,nearestPoint);
						co = (cos(35)*980);
						TopLine = sqrt((980*980)-(co*co));
						Multi = 980/TopLine;
						
						if(enemyToSelf<PtoO*Multi)
							continue;

					}
					
					dist = distance(self.origin,player.origin);
					multi = 300/dist;
					if(multi<1)
						multi = 1;
					if(i == 14)
						player thread waitToDie(self, (3/randomIntRange(5,15)));
					player setVelocity(player getVelocity() + (AtF[0]*(200*(multi)),AtF[1]*(200*(multi)),(AtF[2]+0.25)*(200*(multi))));
					player ViewKick(100,self.origin);
				}
			}
			self setWeaponAmmoClip("javelin_mp", 0);
			self iPrintLnBold("^3"+self.thunderammo+" Shots Left");
		}
		wait 0.1;
	}
}

thunderGunDamage_old(){
	while(1)
	{	self waittill ( "weapon_fired" );
		if( self getCurrentWeapon() == "javelin_mp" )
		{	
			foreach(player in level.players)
			{	
				if(player != self)
				{	
					if(Distance(self.origin, player.origin) < 600)
					{
						if(self player_looking_at(player.origin, 0.7) || self player_looking_at(player getTagOrigin("j_head"), 0.7)){
							player thread ThunDamage(self);
						}
					}
				}
			}
		}
	}
}

player_looking_at( start, dot )
{
	end = self GetEye();
	angles = VectorToAngles( start - end );
	forward = AnglesToForward( angles );
	player_angles = self GetPlayerAngles();
	player_forward = AnglesToForward( player_angles );
	
	new_dot = VectorDot( forward, player_forward ); 
	//iprintln(self.hashelpwithbuttons);
	if ( new_dot < 1 && self.hashelpwithbuttons )
		return true;
	if ( new_dot < dot )
		return false;

	trace = BulletTrace( start, end, false );
	return trace[ "fraction" ] == 1;
}

ThunDamage(attacker)
{	self endon("disconnect");
	target = attacker.angles;
	
	for(m = 4; m > 0; m--){
		if(target[1] > -180 && target[1] < -140)
			self setvelocity(self getvelocity()+(-1000,-500,randomInt(500)));
		else if(target[1] > -140 && target[1] < -100)
			self setvelocity(self getvelocity()+(-500,-1000,randomInt(500)));
		else if(target[1] > -100 && target[1] < -60)
			self setvelocity(self getvelocity()+(250,-1000,randomInt(500)));
		else if(target[1] > -60 && target[1] < -20)
			self setvelocity(self getvelocity()+(1000,-700,randomInt(500)));
		else if(target[1] > -20 && target[1] < 20)
			self setvelocity(self getvelocity()+(1000,0,randomInt(500)));
		else if(target[1] > 20 && target[1] < 60)
			self setvelocity(self getvelocity()+(1000,900,randomInt(500)));
		else if(target[1] > 60 && target[1] < 100)
			self setvelocity(self getvelocity()+(100,1000,randomInt(500)));
		else if(target[1] > 100 && target[1] < 140)
			self setvelocity(self getvelocity()+(-600,1000,randomInt(500)));
		else if(target[1] > 140 && target[1] < 180)
			self setvelocity(self getvelocity()+(-1000,300,randomInt(500)));
		wait 0.1;
	}
	self setvelocity(0,0,0);
}

waitToDie(attacker, time){
	wait time;
	RadiusDamage(self.origin,1,600,1,attacker);
}

StingerPro()
{
	self endon("death");
	self giveWeapon( "rpg_mp" );
	self setWeaponAmmoClip( "rpg_mp", 1 );
	self setWeaponAmmoStock( "rpg_mp", 0 );
	wait 0.1;
	self switchToWeapon( "rpg_mp" );
	while(isalive(self))
	{
		if(self AttackButtonPressed() && self getCurrentWeapon()  == "rpg_mp")
		{
			for(i=0;i<7;i++){
				MagicBullet( "rpg_mp", self getTagOrigin("tag_eye"), self GetCursorPos(), self );
				wait 0.05;
			}
			self iPrintlnBold("^1Reloading!");
			wait 60;
			self iPrintlnBold("^2RPG Pro Is Ready To Fire!");
			self setWeaponAmmoClip( "rpg_mp", 1 );
		}
		wait 0.1;
	}
}

checkOption(option, round){
	if(self.team == "allies" && !self.humanSkills[option]){
		if(level.roundz >= round){
			self setClientDvar("ui_hextra_"+option, 1);
			self setClientDvar("ui_price_"+option, "$"+getDvarInt("price_"+option));
		}
		else{
			self setClientDvar("ui_hextra_"+option, 0);
			self setClientDvar("ui_price_"+option, "Locked Until Round "+round);
		}
	}
	else if(self.team == "axis" && !self.zombieSkills[option]){
		if(level.roundz >= round){
			self setClientDvar("ui_z_"+option, 1);
			self setClientDvar("ui_zprice_"+option, "$"+getDvarInt("zprice_"+option));
		}
		else{
			self setClientDvar("ui_z_"+option, 0);
			self setClientDvar("ui_zprice_"+option, "Locked Until Round "+round);
		}
	}
}

enableRoundOptions(){
	if(self.team == "allies"){
		self checkOption("bow", 2);
		self checkOption("infammo", 3);
		self checkOption("ac130", 3);
		self checkOption("raygun", 4);
		self checkOption("thundergun", 4);
		self checkOption("nuke", 5);
	}
	else if(self.team == "axis"){
		if(!self.zombieSkills["flying"])
			self checkOption("flame", 2);
		self checkOption("blackouth", 4);
		if(!self.zombieSkills["flame"])
			self checkOption("flying", 5);
		self checkOption("invis", 5);
		self checkOption("predator", 5);
	}
}

unlockOptions(){
	if(self.team == "allies"){
		switch(level.roundz){
			case 2:
			self unlockText("^3Unlimited Ammo Unlocked!");
			self unlockText("^3AC130 Unlocked!");
			break;
			case 3:
			self unlockText("^3Thundergun Unlocked!");
			self unlockText("^3Raygun Unlocked!");
			break;
			case 4:
			self unlockText("^3Nuke Unlocked!");
			break;
		}
	}
	else if(self.team == "axis"){
		switch(level.roundz){
			case 2:
			self unlockText("^3Flame Zombie Unlocked!");
			self unlockText("^3Flying Zombie Unlocked!");
			break;
			case 3:
			self unlockText("^3Blackout Humans Unlocked!");
			break;
			case 4:
			self unlockText("^3Invisibility Unlocked!");
			//self unlockText("^3Predator Missile Unlocked!");
			break;
		}
	}
}

doExchangeWeapons()
{
	switch(self.exTo)
	{
		case "LMG":
			if(self.money >= level.StorePrice["LMG"]){
				self.money -= level.StorePrice["LMG"];
				self takeWeapon(self getCurrentWeapon());
				self giveWeapon(self.assingedWeapon["LMG"] + "_mp", 0, false);
				self GiveStartAmmo(self.assingedWeapon["LMG"] + "_mp");
				self switchToWeapon(self.assingedWeapon["LMG"] + "_mp");
				self iPrintlnBold("^2Light Machine Gun Brought!");
				
			} else {
				self iPrintlnBold("^1Need More ^3$$");
			}
			break;
		case "Sniper Rifle":
			if(self.money >= level.StorePrice["Sniper Rifle"]){
				self.money -= level.StorePrice["Sniper Rifle"];
				self takeWeapon(self getCurrentWeapon());
				self giveWeapon(self.assingedWeapon["Sniper"] + "_mp", 0, false);
				self GiveStartAmmo(self.assingedWeapon["Sniper"] + "_mp");
				self switchToWeapon(self.assingedWeapon["Sniper"] + "_mp");
				self iPrintlnBold("^2Sniper Rifle Brought!");
				
			} else {
				self iPrintlnBold("^1Need More ^3$$");
			}
			break;
		case "Assault Rifle":
			if(self.money >= level.StorePrice["Assault Rifle"]){
				self.money -= level.StorePrice["Assault Rifle"];
				self takeWeapon(self getCurrentWeapon());
				self giveWeapon(self.assingedWeapon["AR"] + "_mp", 0, false);
				self GiveStartAmmo(self.assingedWeapon["AR"] + "_mp");
				self switchToWeapon(self.assingedWeapon["AR"] + "_mp");
				self iPrintlnBold("^2Assault Rifle Brought!");
				
			} else {
				self iPrintlnBold("^1Need More ^3$$");
			}
			break;
		case "Machine Pistol":
			if(self.money >= level.StorePrice["Machine Pistol"]){
				self.money -= level.StorePrice["Machine Pistol"];
				self takeWeapon(self getCurrentWeapon());
				self giveWeapon(self.assingedWeapon["MachinePistol"] + "_mp", 0, false);
				self GiveStartAmmo(self.assingedWeapon["MachinePistol"] + "_mp");
				self switchToWeapon(self.assingedWeapon["MachinePistol"] + "_mp");
				self iPrintlnBold("^2Machine Pistol Brought!");
				
			} else {
				self iPrintlnBold("^1Need More ^3$$");
			}
			break;
		default:
			break;
	}
}

selfZombieMenuDvars(){
	if(!self.haveZombieDvars){
		self.haveZombieDvars = true;
	//Zombie DVARs
	self setClientDvar("ui_price_lightweight", "$"+getDvarInt("price_lightweight"));
	self setClientDvar("ui_price_lightweightpro", "$"+getDvarInt("price_lightweightpro"));
	self setClientDvar("ui_price_ninja", "$"+getDvarInt("price_ninja"));
	self setClientDvar("ui_price_ninjapro", "$"+getDvarInt("price_ninjapro"));
	self setClientDvar("ui_price_cold", "$"+getDvarInt("price_cold"));
	self setClientDvar("ui_price_coldpro", "$"+getDvarInt("price_coldpro"));

	self setClientDvar("ui_zprice_50hp", "$"+getDvarInt("zprice_50hp"));
	self setClientDvar("ui_zprice_thermal", "$"+getDvarInt("zprice_thermal"));
	self setClientDvar("ui_zprice_knife", "$"+getDvarInt("zprice_knife"));
	self setClientDvar("ui_zprice_slowh", "$"+getDvarInt("zprice_slowh"));
	self setClientDvar("ui_zprice_1500hp", "$"+getDvarInt("zprice_1500hp"));
	self setClientDvar("ui_zprice_fasttac", "$"+getDvarInt("zprice_fasttac"));
	self setClientDvar("ui_zprice_radio", "$"+getDvarInt("zprice_radio"));

    //Zombies
    self setClientDvar("ui_zperk_0", 1);
    self setClientDvar("ui_zperk_1", 1);
    self setClientDvar("ui_zperk_2", 1);
    self setClientDvar("ui_zperkpro_0", 0);
    self setClientDvar("ui_zperkpro_1", 0);
    self setClientDvar("ui_zperkpro_2", 0);
    self setClientDvar("ui_z_50hp", 1);
    self setClientDvar("ui_z_thermal", 1);
    self setClientDvar("ui_z_knife", 1);
    self setClientDvar("ui_z_radio", 0);
    self setClientDvar("ui_z_slowh", 1);
    self setClientDvar("ui_z_1500hp", 1);
    self setClientDvar("ui_z_fasttac", 1);

	self thread enableRoundOptions();
	}
}

selfHumanDvars(){
	if(!self.selfHumanDvars){
		self.selfHumanDvars = 1;

	self setClientDvar("ui_price_upgrade", "$"+getDvarInt("price_upgrade"));
	self setClientDvar("ui_price_maxammo", "$"+getDvarInt("price_maxammo"));
	self setClientDvar("ui_price_akimbo","$"+getDvarInt("price_akimbo"));
	self setClientDvar("ui_price_fmj", "$"+getDvarInt("price_fmj"));
	self setClientDvar("ui_price_reflex", "$"+getDvarInt("price_reflex"));
	self setClientDvar("ui_price_xmag", "$"+getDvarInt("price_xmag"));

	self setClientDvar("ui_price_nvision", "$"+getDvarInt("price_nvision"));
	self setClientDvar("ui_price_tversion", "$"+getDvarInt("price_tversion"));
	self setClientDvar("ui_price_rshield", "$"+getDvarInt("price_rshield"));
	self setClientDvar("ui_price_50hp", "$"+getDvarInt("price_50hp"));
	self setClientDvar("ui_price_sentry", "$"+getDvarInt("price_sentry"));
	self setClientDvar("ui_price_monkey", "$"+getDvarInt("price_freeze"));
	self setClientDvar("ui_price_mine", "$"+getDvarInt("price_mine"));
	self setClientDvar("ui_price_rpg", "$"+getDvarInt("price_rpg"));
	self setClientDvar("ui_price_uav", "$"+getDvarInt("price_uav"));

	self setClientDvar("ui_price_sleight", "$"+getDvarInt("price_sleight"));
	self setClientDvar("ui_price_sleightpro", "$"+getDvarInt("price_sleightpro"));
	self setClientDvar("ui_price_sitrep", "$"+getDvarInt("price_sitrep"));
	self setClientDvar("ui_price_sitreppro", "$"+getDvarInt("price_sitreppro"));
	self setClientDvar("ui_price_power", "$"+getDvarInt("price_power"));
	self setClientDvar("ui_price_powerpro", "$"+getDvarInt("price_powerpro"));
	self setClientDvar("ui_price_steady", "$"+getDvarInt("price_steady"));
	self setClientDvar("ui_price_steadypro", "$"+getDvarInt("price_steadypro"));
	self setClientDvar("ui_price_cold", "$"+getDvarInt("price_cold"));
	self setClientDvar("ui_price_coldpro", "$"+getDvarInt("price_coldpro"));


    //Client Store DVARs
    //Humans
    self setClientDvar("ui_smg_menu", 1);
    self setClientDvar("ui_ass_menu", 0);
    self setClientDvar("ui_lmg_menu", 0);
    self setClientDvar("ui_pistol_menu", 1);
    self setClientDvar("ui_mpistol_menu", 0);
    self setClientDvar("ui_sniper_menu", 0);
    self setClientDvar("ui_fmj_0", 1);
    self setClientDvar("ui_reflex_0", 1);
    self setClientDvar("ui_xmag_0", 1);
    self setClientDvar("ui_akimbo_0", 1);
    self setClientDvar("ui_fmj_1", 1);
    self setClientDvar("ui_fmj_2", 1);
    self setClientDvar("ui_reflex_2", 1);
    self setClientDvar("ui_xmag_2", 1);
    self setClientDvar("ui_akimbo_2", 1);
    self setClientDvar("ui_perk_0", 1);
    self setClientDvar("ui_perk_1", 1);
    self setClientDvar("ui_perk_2", 1);
    self setClientDvar("ui_perk_3", 1);
    self setClientDvar("ui_perk_4", 1);
    self setClientDvar("ui_perk_5", 1);
    self setClientDvar("ui_perkpro_0", 0);
    self setClientDvar("ui_perkpro_1", 0);
    self setClientDvar("ui_perkpro_2", 0);
    self setClientDvar("ui_perkpro_3", 0);
    self setClientDvar("ui_perkpro_4", 0);
    self setClientDvar("ui_perkpro_5", 0);
    self setClientDvar("ui_hextra_nightv", 1);
    self setClientDvar("ui_hextra_thermal", 1);
    self setClientDvar("ui_hextra_rpg", 1);
    self setClientDvar("ui_hextra_monkey", 1);
    self setClientDvar("ui_hextra_mine", 1);
    self setClientDvar("ui_hextra_uav", 1);
    self setClientDvar("ui_hextra_sentry", 1);
    self setClientDvar("ui_hextra_50hp", 1);
	//self setClientDvar("ui_reflex_1", 1);
    //self setClientDvar("ui_xmag_1", 1);
    //self setClientDvar("ui_akimbo_1", 1);

	self thread enableRoundOptions();
	}
}

setMenuDvars(){
	//Human DVARs
	setDvar("price_upgrade", 200);
	setDvar("price_maxammo", 150);
	setDvar("price_akimbo", 150);
	setDvar("price_fmj", 100);
	setDvar("price_reflex", 100);
	setDvar("price_xmag", 150);

	setDvar("price_nvision", 200);
	setDvar("price_tversion", 350);
	setDvar("price_rshield", 100);
	setDvar("price_bow", 400);
	setDvar("price_50hp", 350);
	setDvar("price_sentry", 200);
	setDvar("price_infammo", 800);
	setDvar("price_freeze", 450);
	setDvar("price_mine", 100);
	setDvar("price_rpg", 400);
	setDvar("price_thundergun", 1000);
	setDvar("price_raygun", 1250);
	setDvar("price_ac130", 800);
	setDvar("price_uav", 100);
	setDvar("price_nuke", 2500);

	setDvar("price_sleight", 100);
	setDvar("price_sleightpro", 150);
	setDvar("price_sitrep", 100);
	setDvar("price_sitreppro", 150);
	setDvar("price_power", 200);
	setDvar("price_powerpro", 50);
	setDvar("price_steady", 50);
	setDvar("price_steadypro", 200);

	//Both Human and Zombie DVARs
	setDvar("price_cold", 100);
	setDvar("price_coldpro", 50);

	//Zombie DVARs
	setDvar("price_lightweight", 100);
	setDvar("price_lightweightpro", 50);
	setDvar("price_ninja", 200);
	setDvar("price_ninjapro", 100);

	setDvar("zprice_50hp", 50);
	setDvar("zprice_thermal", 50);
	setDvar("zprice_knife", 300);
	setDvar("zprice_invis", 500);
	setDvar("zprice_radio", 800);
	setDvar("zprice_flame", 700);
	setDvar("zprice_slowh", 200);
	setDvar("zprice_1500hp", 500);
	setDvar("zprice_predator", 1000);
	setDvar("zprice_flying", 700);
	setDvar("zprice_blackouth", 750);
	setDvar("zprice_fasttac", 200);
}